<?php

/**
 * @package EasyImageRotator
 * @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

namespace CodeNinja\Component\EasyImageRotator\Administrator\View\Images;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;

/**
 * HTML View class for the HelloWorld Component
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\CMS\Object\CMSObject
	 */
	protected $state;

	/**
	 * The canDo state
	 *
	 * @var  \Joomla\CMS\Object\???
	 */
	protected $canDo;

	/**
	 * The CpHelper class instance
	 *
	 * @var  \CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper
	 */
	protected $cpHelper;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->canDo	= ContentHelper::getActions(CpHelper::$extensionName, 'images', $this->item->id);
		$this->cpHelper = new CpHelper();

		//pre-load model and view data
		$model = $this->getModel();
		$this->menuItems = $this->cpHelper->getMenuList();
		$this->defaultItem = $this->cpHelper->getDefaultMenuItem($this->menuItems);

		// Set the toolbar
		$this->addToolBar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		Factory::getApplication()->input->set('hidemainmenu', false);
		$isNew = ($this->item->id == 0);

		// Built the actions for new and existing records.
		$canDo = $this->canDo;

		ToolBarHelper::title(Text::_('COM_EASYIMAGEROTATOR_MANAGER_TITLE'), 'images');

		// For new records, check the create permission.
		if ($isNew && $canDo->get('core.create')) {
			ToolbarHelper::apply('images.apply');
			ToolbarHelper::save('images.save');
			//ToolbarHelper::save2new('images.save2new');
			ToolbarHelper::cancel('images.cancel');
		} else {
			if ($canDo->get('core.edit')) {
				ToolbarHelper::apply('images.apply');
				ToolbarHelper::save('images.save');

				// We can save this record, but check the create permission to see if we can return to make a new one.
				//if ($canDo->get('core.create'))
				//{
				//	ToolbarHelper::save2new('images.save2new');
				//}
			}

			// If checked out, we can still save
			/**if ($canDo->get('core.create'))
			{
				ToolbarHelper::save2copy('images.save2copy');
			}**/
			ToolbarHelper::cancel('images.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
