<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Helper\ModuleHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;
use CodeNinja\Module\EasyImageRotator\Site\Helper\EasyImageRotatorModuleHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\HtmlHelper as EasyImageRotatorHtmlHelper;


// Include the syndicate functions only once
$modEasyImageRotatorHelper = new EasyImageRotatorModuleHelper();

if (!file_exists(JPATH_ADMINISTRATOR . '/components/'. CpHelper::$extensionName . '/src/Helper/HtmlHelper.php')) {
	echo Text::_('This module is nothing without the Easy Image Rotator component!<br><br><strong> Please install this component first!</strong>');
	return;
}

$arrImages 				= null;
$strCurrentModuleID 	= (($module!=null) ? $module->id : 0);
$active_menuItemId 		= $modEasyImageRotatorHelper->getMenu();
$objImgResult			= $modEasyImageRotatorHelper->getImgEntry($active_menuItemId);

//Parameter Setup for this Module and Views
//Basics
$paramIsUseFallbackImages 			= ($params->get("useFallbackImages", 1) == 1 ? true : false);
$paramSelectedFittingOption 		= ($params->get("fitting") != "" ? $params->get("fitting") : "0");
$paramIsResponsive 					= $params->get("isResponsive", 1);
$paramIntWidth 						= ($params->get("width") != "" ? $params->get("width") : 250);
$paramIntHeight						= ($params->get("height") != "" ? $params->get("height") : 80);

$paramIsShuffleImages				= ($params->get("shuffleImages", 0) == 1 ? true : false);
//SpecificImagePath
$paramIsUseSpecificImagePath 		= ($params->get("useSpecificImagePath", 0) == 1 ? true : false);
$paramSpecificImagePath 			= ($params->get("specificImagePath") != "" ? $params->get("specificImagePath") : "images");
//Slider
$paramIsDisplayAsImageSlider 		= ($params->get("displayAsImageSlider", 1) == 1 ? true : false); /** displayAsImageSlider = 1 display as js slider, displayAsImageSlider = 2 display as normal image **/
$paramIsSliderCropImages			= ($params->get("sliderCropImages", 0) == 1 ? true : false);
$paramIntSliderPauseTime			= (($params->get("sliderPauseTime") != "") ? $params->get("sliderPauseTime") : 3000);
$paramIntSliderEffect				= (($params->get("sliderEffect") != "") ? $params->get("sliderEffect") : 0);

$paramIntNumberOfImagesToLoad		= (($params->get("numberOfImagesToLoad") > 0) ? $params->get("numberOfImagesToLoad") : 1);
$paramIsDisplayImageTitle 			= ($params->get("displayImageTitle", 1) == 1 ? true : false);
$paramIsDisplayHtmlCaption 			= ($params->get("displayHtmlCaption", 1) == 1 ? true : false);
$paramIntSliderAnimationSpeed 		= (($params->get("animationSpeed") != "") ? $params->get("animationSpeed") : 500);

//Setup HelperClass properties
$modEasyImageRotatorHelper->intWidth = $paramIntWidth;
$modEasyImageRotatorHelper->intHeight = $paramIntHeight;
$modEasyImageRotatorHelper->intNumberOfImagesToLoad = $paramIntNumberOfImagesToLoad;
$modEasyImageRotatorHelper->isShuffleImages = $paramIsShuffleImages;
$modEasyImageRotatorHelper->strSelectedFittingOption = $paramSelectedFittingOption;
$modEasyImageRotatorHelper->isUseSpecificImagePathEnabled = $paramIsUseSpecificImagePath;
$modEasyImageRotatorHelper->strSpecificImagePath = $paramSpecificImagePath;

if($objImgResult != null)
{
	//If fallback for image directory has been set
	if($paramIsUseFallbackImages && !$modEasyImageRotatorHelper->isImgEntryUrlValid($objImgResult))
	{
		$objImgResult 	= $modEasyImageRotatorHelper->getImgEntry(0);
		$arrImages 		= $modEasyImageRotatorHelper->setUpImages($objImgResult);
	}
	else
	{
		$arrImages = $modEasyImageRotatorHelper->setUpImages($objImgResult);
	}

	//Text and Caption setup
	$strImageTitle = ($paramIsDisplayImageTitle) ? $objImgResult->img_title : '';
	$strHtmlCaptionText = ($paramIsDisplayHtmlCaption) ? $objImgResult->img_textlayer : '';
}

print EasyImageRotatorHtmlHelper::getVersionTag();
require ModuleHelper::getLayoutPath(CpHelper::$moduleName, $params->get('layout', 'default'));
?>