<?php

/**
 * @package EasyImageRotator
 * @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\HtmlHelper as EasyImageRotatorHtmlHelper;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive');
$wa->useScript('form.validate');

?>
<style type="text/css">
	a[target="_blank"]:before {
		content: '';
	}
</style>

<div>
	<img src="/administrator/components/com_easyimagerotator/assets/icons/logo-128.png" style="float:left;margin-right:10px;">

	<div style="width:600px;float:right;margin-left:10px;border:1px solid #cccccc;background:#ffffff;padding:10px">
		<h3><a href="https://codeninja.eu/joomla-extensions/easy-image-rotator" target="_blank"><?php echo JText::_('COM_EASYIMAGEROTATOR_HELP_TITLE'); ?> </a></h3>
		<p><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_DESC'); ?></p>
		<p>
			<strong><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_INSTRUCTIONS'); ?></strong>
		<ul>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_IMAGEROOT'); ?></li>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_USE_FALLBACK'); ?></li>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_SPECIFICIMAGEORPATH'); ?></li>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_NOIMAGE'); ?></li>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_JS_SLIDER_ENABLE'); ?></li>
			<li><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_JS_SLIDER_TEXT'); ?></li>
		</ul>
		</p>
	</div>

	<br />
	<p>
		<a href="https://codeninja.eu/joomla-extensions/easy-image-rotator#docs" target="_blank"><?php echo ($lang->_('COM_EASYIMAGEROTATOR_HELP_LINKS_DOCUMENTATION')); ?></a> |
		<a href="https://codeninja.eu/joomla-extensions/easy-image-rotator#support" target="_blank"><?php echo ($lang->_('COM_EASYIMAGEROTATOR_HELP_LINKS_SUPPORT')); ?></a> |
		<a href="https://codeninja.eu/joomla-extensions/easy-image-rotator#download" target="_blank"><?php echo ($lang->_('COM_EASYIMAGEROTATOR_HELP_LINKS_DOWNLOADLATEST')); ?></a>
	</p>
	<p><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_LICENSE'); ?></p>
	<p><?php echo Text::_('COM_EASYIMAGEROTATOR_HELP_DONATE'); ?></p>
		<div class="container">
			<div class="row">
				<div class="col-sm-2">
					<a href="https://paypal.me/dablumino" target="_blank">
						<img src="/administrator/components/com_easyimagerotator/assets/icons/paypal-donate-button.png" width="220px" />
					</a>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<script type="text/javascript" src="https://cdnjs.buymeacoffee.com/1.0.0/button.prod.min.js" data-name="bmc-button" data-slug="dablumino" data-color="#FFDD00" data-emoji="" data-font="Cookie" data-text="Buy me a coffee" data-outline-color="#000000" data-font-color="#000000" data-coffee-color="#ffffff"></script>
				</div>
				<div class="col">
					<img src="/administrator/components/com_easyimagerotator/assets/icons/bmc_qr.png" width="150" />
				</div>
			</div>
		</div>

</div>

<div align="center" style="clear: both">
	<br><?php echo sprintf(Text::_('COM_EASYIMAGEROTATOR_FOOTER'), EasyImageRotatorHtmlHelper::getVersionTag(true)); ?> &nbsp; <a href="https://codeninja.eu/" target="_blank" title="codeninja.eu">codeninja.eu</a>
</div>