<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyImageRotator\Administrator\Helper;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;

/**
 * EasyImageRotator Html helper class.
 */
class HtmlHelper
{
	/**
	 * Method to get the installed Version as string
	 * @return html string
	**/
	public static function getVersionTag($isOnlyVersion = false)
	{
		$name = '';
		$version = '';
		$file = JPATH_ADMINISTRATOR . '/components/com_easyimagerotator/easyimagerotator.xml';
		if(file_exists($file))
		{
			$xml = simplexml_load_file($file);
			$v = $xml->xpath('//extension');
			if(count($v) > 0)
			{
				$name = $v[0]->name;
				$version = $v[0]->version;
			}
		}

		if($isOnlyVersion) {
			return 'v' . $version;
		} else {
			return '<!-- '.$name.' v' . $version . ' -->';
		}
	}

	/**
	 * Method Displays a multi-dimensional array as a HTML unordered lists.
	 * @return html string
	**/
	public function displayArrayAsTree($array, $isFirst=true) 
	{
		$output = "";

		if( $isFirst )
		{
			$output .= "Start Display as Tree<br>";
		}

		$newline = "<br>";
		//cycle through each item in the array as key => value pairs
		foreach($array as $key => $value) 
		{
		   if (is_array($value) || is_object($value)) 
		   {
		      //call it out as such, surround with brackets, and recursively call displayTree.
		       $value = "Array()" . $newline . "(<ul>" . $this->displayArrayAsTree($value, false) . "</ul>)" . $newline;
		   }
		  //if value isn't an array, it must be a string. output its' key and value.
		  $output .= "[$key] => " . $value . $newline;
		}
		return $output;
	}
}

?>