<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\HtmlHelper as EasyImageRotatorHtmlHelper;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive');
$wa->useScript('form.validate');

$app = Factory::getApplication();
$input = $app->input;
?>

<style type="text/css">
	div.easyimagerotatorArea {
		margin-bottom:18px;
	}
	
	div.easyimagerotatorArea .collapsible-content-title {
		font-weight:bold;
	}
	
	div.collapsible-content, .collapsible-content-title { 
		max-width:80%;
	}
	
	div.easyimagerotatorContent div { 

	}
	
	div.easyimagerotatorContent div label {
		display:block;
		float:left;
		min-width:180px;
	}
	
	div.easyimagerotatorContent div textarea {
		min-width:385px;
		max-width:560px;
	}
	
	.collapsible-content-title {
		font-size:120%;
		font-weight:bold;
		text-transform:uppercase;
		background-color:#D3D3D3;
		margin:0 0 5px 0;
	}
	
	.collapsible-content-title a:hover {
		background-color:#EEEEEE;
		text-decoration:none;
	}
	
	.collapsible-content-title a {
		display:block;
		line-height:24px;
		padding:10px 10px 10px 10px;
		cursor:pointer;
	}
	
	.icon {
		width:20px;
		height:20px;
		display:block;
		margin:12px 4px 0 4px;
		float:left;
		cursor:pointer;
	}
	
	.icon.arrowDown {
		background: url(<?php echo URI::base(true).'/components/com_easyimagerotator/assets/icons/'; ?>arrow-down.png) no-repeat;
	}
	
	.icon.arrowUp {
		background: url(<?php echo URI::base(true).'/components/com_easyimagerotator/assets/icons/'; ?>arrow-up.png) no-repeat;
	}
</style>


<form id="adminForm" name="adminForm" method="POST" action="<?php echo Route::_('index.php?option='. CpHelper::$extensionName); ?>">
	<div style="float:right;width:250px;border:1px solid #cccccc;background:#ffffff;padding:10px">
		<p><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_INSTRUCTIONS'); ?> </p>
		<p><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_INSTRUCTIONS_FALLBACK'); ?> </p>
	</div>
	
	<div class="collapsible-content-title"><span class="icon arrowUp">&nbsp;</span><a>default - fallback</a></div>
	<div class="collapsible-content">
		<!-- default fallback start -->
		<div class="easyimagerotatorArea">
			<div class="easyimagerotatorTitle"><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_MENUITEM') ?> - Default - Fallback (ID:0)</div>
			<div class="easyimagerotatorContent">
				<div>
					<label><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_IMAGEURL') ?></label>
					<input type="text" name="menu_url_<?php echo $this->defaultItem->id;?>" size="60" value="<?php echo ($this->defaultItem->img != '') ? $this->defaultItem->img : ''; ?>" />
				</div>
				
				<div>
					<label><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_IMAGETITLE') ?></label>
					<input type="text" name="menu_title_<?php echo $this->defaultItem->id;?>" size="60" value="<?php echo ($this->defaultItem->img_title != '') ? $this->defaultItem->img_title : ''; ?>" />
				</div>
				
				<div>
					<textarea rows="4" cols="120" name="menu_textlayer_<?php echo $this->defaultItem->id;?>"><?php echo ($this->defaultItem->img_textlayer != '') ? $this->defaultItem->img_textlayer : ''; ?></textarea>
				</div>
				<input type="hidden" name="menu_id[]" value="<?php echo $this->defaultItem->id;?>" />
			</div>
		</div>
		<!-- default fallback end -->
	</div>
	<?php

	if($this->menuItems)
	{
		foreach($this->menuItems as $itemKey => $arrValues) {
			$arrTmp = $this->getModel()->getMenuItemByID($arrValues, 0);
			$isDefaultMenuItem = (is_array($arrTmp)) ? true : false;
			if(!$isDefaultMenuItem) {
		?>
			<div class="collapsible-content-title"><span class="icon arrowUp">&nbsp;</span><a><?php echo $itemKey.' ('.count($arrValues).' elements)' ; ?></a></div>
			<div class="collapsible-content">
				<?php foreach($arrValues as $menuItemKey => $arrMenuItem) {
					if ($arrMenuItem['parent_id'] > 0) { ?>
						<!-- regular item start -->
						<div class="easyimagerotatorArea">
							<div class="easyimagerotatorTitle"><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_MENUITEM') ?> - <?php echo $arrMenuItem['title'];?> (ID:<?php echo $arrMenuItem['id'];?>)</div>
							<div class="easyimagerotatorContent">
								<div>
									<label><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_IMAGEURL') ?></label>
									<input type="text" name="menu_url_<?php echo $arrMenuItem['id'];?>" size="60" value="<?php echo ($arrMenuItem['img']!='') ? $arrMenuItem['img'] : ''; ?>" filter="raw" />
								</div>
								
								<div>
									<label><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_IMAGETITLE') ?></label>
									<input type="text" name="menu_title_<?php echo $arrMenuItem['id'];?>" size="60" value="<?php echo ($arrMenuItem['img_title']!='') ? $arrMenuItem['img_title'] : ''; ?>" filter="raw" />
								</div>
								
								<div>
								<label><?php echo Text::_('COM_EASYIMAGEROTATOR_DEFAULT_IMAGETEXTLAYER') ?></label>
									<textarea rows="4" cols="120" name="menu_textlayer_<?php echo $arrMenuItem['id'];?>"><?php echo ($arrMenuItem['img_textlayer']!='') ? $arrMenuItem['img_textlayer'] : ''; ?></textarea>
								</div>
								<input type="hidden" name="menu_id[]" value="<?php echo $arrMenuItem['id'];?>" />
							</div>
						</div>
						<!-- regular item end -->
					<?php } ?>
				<?php } ?>
				
			</div>
		<?php
			} //if
		} //foreach
	} //if

	?>
	
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<?php echo HTMLHelper::_('form.token'); ?>
	</form>
	
	<script type="text/javaScript">
		window.addEventListener("DOMContentLoaded", (event) => {
			var elementsArray = document.querySelectorAll('.collapsible-content-title');
			if(elementsArray)
			{
				console.log('l' + elementsArray.length)
				elementsArray.forEach(function(elem) {
					console.log('t' + elem);
					elem.addEventListener("click", function() {
						console.log('test');
						if (this.nextSibling.nextSibling.style.display === "none") 
						{
							this.nextSibling.nextSibling.style.display = "block";
						} else {
							this.nextSibling.nextSibling.style.display = "none";
						}

						var icon = this.querySelector('.icon');
						icon.classList.toggle('arrowUp');
						icon.classList.toggle('arrowDown');
					});
				});
		}
		});
	</script>


<div align="center" style="clear: both">
	<br><?php echo sprintf(Text::_('COM_EASYIMAGEROTATOR_FOOTER'), EasyImageRotatorHtmlHelper::getVersionTag(true));?> &nbsp; <a href="https://codeninja.eu/" target="_blank" title="codeninja.eu">codeninja.eu</a>
</div>