<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;


HTMLHelper::_('bootstrap.framework');

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseScript(CpHelper::$moduleName .'_jquery-3.7.1-js', 'modules/' . CpHelper::$moduleName . '/js/jquery-min.js');
$wa->registerAndUseScript(CpHelper::$moduleName .'_nivo.sliderjs', 'modules/' . CpHelper::$moduleName . '/js/jquery.nivo.slider.pack.js');
$wa->registerAndUseScript(CpHelper::$moduleName .'_fakecropjs', 'modules/' . CpHelper::$moduleName . '/js/jquery.fakecrop.js');
$wa->registerAndUseScript(CpHelper::$moduleName .'_functionsjs', 'modules/' . CpHelper::$moduleName . '/js/functions.js');
//load css
$wa->registerAndUseStyle(CpHelper::$moduleName .'nivo-slider-themes', 'modules/' . CpHelper::$moduleName . '/css/themes/default/default.css'); //CSS for this Module
$wa->registerAndUseStyle(CpHelper::$moduleName .'nivo-slider', 'modules/' . CpHelper::$moduleName . '/css/nivo-slider.css'); 

if(!$paramIsDisplayAsImageSlider)
{
	//check for available images
	if(is_array($arrImages) && count($arrImages) > 0)
	{
		if($paramIsResponsive)
		{
			echo '<div class="img-container"><img class="img-responsive" src="'.$arrImages[0]['URL'].'" alt="'.$strImageTitle.'" title="'.$strImageTitle.'" /></div>';
		}
		else
		{
			echo '<div style="height:'.$arrImages[0]['HEIGHT'].'px;width:'.$arrImages[0]['WIDTH'].'px;overflow:hidden;">
					<img class="" src="'.$arrImages[0]['URL'].'" height="'.$arrImages[0]['HEIGHT'].'" alt="'.$strImageTitle.'" title="'.$strImageTitle.'" width="'.$arrImages[0]['WIDTH'].'" />
				</div>';
		}
	}
	else
	{
		//display error
		echo '<strong>Error:</strong> No images have been found in directory';
	}
}
else
{
	$strHtmlCaptionText = '';
	$isHtmlCaptionsEnabled = false;
	if($paramIsDisplayHtmlCaption)
	{
		if(trim($strHtmlCaptionText) != '')
		{
			$isHtmlCaptionsEnabled = true;
		}
	}
	
	//check for available images
	if(is_array($arrImages) && count($arrImages) > 0)
	{
		//Use CropImages only it the mode is not responsive
		$strSliderCropImagesJS = "";
		if(!$paramIsResponsive && $paramIsSliderCropImages)
		{
			$strSliderCropImagesJS .= "
				/** corp images to ensure slider is working with diffrent sized images **/
				if (jQuery().fakecrop){ jQuery('#slider-".$strCurrentModuleID." img').fakecrop({ wrapperWidth:".$paramIntWidth.", wrapperHeight:".$paramIntHeight.", fill: true }); }
			";
		}
		
		$i = 0;
		$strImagesContent = '';
		$strHtmlCaptionContent = '';
		foreach($arrImages as $imgItem) 
		{
			$i++;
			$strImgHtmlCaption = '';
		
			if($isHtmlCaptionsEnabled)
			{
				$strImgHtmlCaption 		= ' title="#htmlcaption-'.$strCurrentModuleID.'-'.$i.'"';
				$strHtmlCaptionContent .= '<div id="htmlcaption-'.$strCurrentModuleID.'-'.$i.'" class="nivo-html-caption">'.$strHtmlCaptionText.'</div>';
			}
		
			$strImgSizes 					= (!$paramIsResponsive) ? ' width="'.$imgItem['WIDTH'].'" height="'.$imgItem['HEIGHT'].'"' : '';
			$strImagesContent .= '<img src="'.$imgItem['URL'].'" '.$strImgSizes.$strImgHtmlCaption.' data-thumb="'.$imgItem['URL'].'" alt="'.$strImageTitle.'" />';
		}
		
		$strSliderStyles = (!$paramIsResponsive) ? ' width:'.$params->get("width").'px;height:'.$params->get("height").'px;' : '';
		echo '<div class="slider-wrapper theme-default" style="'.$strSliderStyles.'">
						<div id="slider-'.$strCurrentModuleID.'" class="nivoSlider" >
							'. $strImagesContent .'
						</div>
						<!-- htmlcaptions -->
						'. $strHtmlCaptionContent .'
				</div>';
				
		?>
			<script type="text/javaScript">
				jQuery(document).ready(function() {
					<?php echo $strSliderCropImagesJS; ?>
					jQuery('#slider-<?php echo $strCurrentModuleID; ?>').nivoSlider({ 
						effect: '<?php echo $modEasyImageRotatorHelper->getMappedEffect($paramIntSliderEffect); ?>',
						animSpeed: <?php echo $paramIntSliderAnimationSpeed; ?>,
						pauseTime: <?php echo $paramIntSliderPauseTime; ?>,
						controlNav: false, 
						controlNavThumbs: false, 
						prevText: 'Prev', 
						nextText: 'Next',
						pauseOnHover: true,
						randomStart: false,
					});
				});
			</script>
		<?php
	}
	else
	{
		//display error
		echo '<strong>Error:</strong> No images have been found in directory';
	}

} //End as image slider
?>

