<?php

/**
 * @package EasyImageRotator
 * @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

namespace CodeNinja\Component\EasyImageRotator\Administrator\Helper;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;
/**
 * EasyImageRotator control panel helper class.
 */
class CpHelper
{
	/* Class properties **/
	private $defaultItemTemplate = array('id' => 0, 'parent_id' => 0, 'title' => 'Default fallback', 'img' => '/images/*', 'img_textlayer' => '', 'img_title' => '');
	private $defaultItem;
	private $menuResults;

	/* Component properties **/
	public static $extensionName = 'com_easyimagerotator';
	public static $extension_prefix = 'EasyImageRotator';
	public static $moduleName = 'mod_easyimagerotator';

	/**
	 * Method to get available actions
	 * @return stdClass actions
	 **/
	public static function getActions()
	{
		$user	= Factory::getUser();
		$result	= new \stdClass;
		$assetName = CpHelper::$extensionName;
		$actions = array('core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.state', 'core.delete');

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	} //getActions

	/**
	 * Method to get menus (properly- ie with indents for submenus!)
	 * @return html string
	 **/
	public function getMenuList()
	{
		// Create a new query object.
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true)
			->clear()
			->select('m.id, m.parent_id, m.title, m.menutype')
			->from('#__menu AS m')
			->where('m.published = 1')
			->order('m.menutype, m.parent_id');

		$db->setQuery($query);
		$this->menuResults = $db->loadObjectList();

		if ($this->menuResults == null) {
			return "No data available!";
		}

		//Prepare Items
		$arrMenuTree = array();
		$intCurrentParentId = 0;
		$strCurrentMenuType = '';
		foreach ($this->menuResults as $item) {
			$strCurrentMenuType = $item->menutype;
			if (!empty($strCurrentMenuType)) {
				if (!array_key_exists($strCurrentMenuType, $arrMenuTree)) {
					$arrMenuTree[$strCurrentMenuType] = array();
				}
				$arrMenuTree[$strCurrentMenuType][] = array(
					'id' => (int)$item->id, 'parent_id' => (int)$item->parent_id, 'title' => $item->title, 'img' => '', 'img_textlayer' => '', 'img_title' => ''
				);
			}
		}

		//Add default fallback entry to list
		$arrMenuTree['default'][] = array(
			'id' => $this->defaultItemTemplate['id'], 'parent_id' => $this->defaultItemTemplate['parent_id'], 'title' => $this->defaultItemTemplate['title'], 'img' => $this->defaultItemTemplate['img'], 'img_textlayer' => $this->defaultItemTemplate['img_textlayer'], 'img_title' => $this->defaultItemTemplate['img_title']
		);

		// now get specified entries from component database!
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true)
			->select($db->quoteName(['id', 'img_url', 'img_textlayer', 'img_title']))
			->from($db->quoteName('#__easyimagerotator'));

		$tmpResults = $db->setQuery($query)->loadObjectList();

		//Merge array objects (2 Levels)
		foreach ($arrMenuTree as $treeIndex => $arrTreeItems) {
			foreach ($arrTreeItems as $itemIndex => $arrMenuItem) {
				foreach ($tmpResults as $tmpItem) {
					if ($arrMenuTree[$treeIndex][$itemIndex]['id'] == $tmpItem->id) {
						$arrMenuTree[$treeIndex][$itemIndex]['img'] = $tmpItem->img_url;
						$arrMenuTree[$treeIndex][$itemIndex]['img_textlayer'] = $tmpItem->img_textlayer;
						$arrMenuTree[$treeIndex][$itemIndex]['img_title'] = $tmpItem->img_title;
						break;
					}
				}
			}
		}

		return $arrMenuTree;
	} //getMenuList

	/**
	 * Method to find the default menu item within the list
	 * @return object of default item
	 **/
	public function getDefaultMenuItem($arrMenuTree)
	{
		$this->defaultItem = $this->defaultItemTemplate;
		$hasBeenFound = false;
		foreach ($arrMenuTree as $arrTreeItems) {
			foreach ($arrTreeItems as $arrMenuItem) {
				if ($arrMenuItem['id'] == 0) {
					$this->defaultItem = $arrMenuItem;
					$hasBeenFound = true;
					break;
				}
			}

			if ($hasBeenFound)
				break;
		}
		return (object)$this->defaultItem;
	} //getDefaultMenuItem
}
