<?php

/**
 * @package EasyImageRotator
 * @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

namespace CodeNinja\Component\EasyImageRotator\Administrator\Model;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\Database\ParameterType;
//use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;


/**
 * Images model for the menue entries
 */
class ImagesModel extends AdminModel
{

	#private $defaultDataItemTemplate = array('id' => 0, 'parent_id' => 0, 'title' => '', 'img' => '', 'img_textlayer' => '', 'img_title' => '');
	public $defaultItem;
	public $menuResults;

	/**
	 * Constructor.
	 *
	 * @param   array  $config       An array of configuration options (name, state, dbo, table_path, ignore_request).
	 *
	 * @see     \Joomla\CMS\MVC\Model\BaseDatabaseModel
	 * @since   3.2
	 */
	public function __construct($config = [])
	{
		parent::__construct($config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app  = Factory::getApplication();

		// Get an empty dummy form.
		$form = null; //$this->loadForm(CpHelper::$extensionName.'.images', 'images', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form)) {
			return false;
		}
		return $form;
	}

	/**
	 * Method to get  a specific menu item by id
	 * @return array of the menu item with the relevant ID
	 **/
	public function getMenuItemByID($arrValues, $id)
	{
		foreach ($arrValues as $menuItemKey => $arrMenuItem) {
			if ($arrMenuItem['id'] == $id) {
				return $arrMenuItem;
			}
		}
		return null;
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   3.0
	 */
	public function save($data)
	{
		if ($data == null) {
			return false;
		}

		$menu_ids = $data->get("menu_id");
		if (is_array($menu_ids)) {
			$db = Factory::getContainer()->get('DatabaseDriver'); //J4 onwards, outside of the Model or Table
			// delete all rows
			$db->setQuery('DELETE FROM #__easyimagerotator');
			$db->execute();

			foreach ($menu_ids as $menuId) {
				if (is_numeric($menuId) && (int)$menuId >= 0) {
					$menu_url = $data->getRaw('menu_url_' . $menuId);
					$menu_textlayer = $data->getString('menu_textlayer_' . $menuId);
					$menu_title = $data->getString('menu_title_' . $menuId);

					// Create a new query object.
					$query = $db->getQuery(true);

					$columns = array('id', 'img_url', 'img_textlayer', 'img_title');
					$values = array(':id', ':img_url', ':img_textlayer', ':img_title');

					// prepare the insert query.
					$query->clear()
						->insert($db->quoteName('#__easyimagerotator'))
						->columns($db->quoteName($columns))
						->values(implode(',', $values));

					$query->bind(':id', $menuId, ParameterType::INTEGER)
						->bind(':img_url', $menu_url)
						->bind(':img_textlayer', $menu_textlayer)
						->bind(':img_title', $menu_title);
					//$query_msg .= "<br>".$query;
					$db->setQuery($query);
					$db->execute();
				}
			}
		}

		return true;
	}
}
