<?php

/**
 * @package EasyGCalendar
 * @Copyright (C) 2011-2024 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

namespace CodeNinja\Component\EasyImageRotator\Administrator\Controller;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Factory;
use CodeNinja\Component\EasyImageRotator\Administrator\Helper\CpHelper;


class ImagesController extends FormController
{
	use VersionableControllerTrait;

	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_EASYIMAGEROTATOR_CPANEL';


	public function save($key = null, $urlVar = 'x_id')
	{
		if (Session::checkToken('get')) {
			Session::checkToken('get') or die('Invalid Token');
		} else {
			Session::checkToken() or die('Invalid Token');
		}

		$app  = Factory::getApplication();
		$data = $app->getInput();

		// Get the model.
		$model = $this->getModel();

		// Remove the items.
		if ($model->save($data)) {
			$this->setMessage(Text::plural('COM_EASYIMAGEROTATOR_SYSTEM_DATASAVEDSUCCESSFULLY', 1));
		}

		//TODO switch redirects
		switch ($this->getTask()) {
			case 'apply':
				$this->setRedirect('index.php?option=' . CpHelper::$extensionName . '&view=images');
				break;

			case 'save':
			default:
				$this->setRedirect('index.php');
				break;
		}
	}

	/**public function edit($key = null, $urlVar = 'x_id')
	{
		return parent::edit($key, $urlVar);
	}**/

	public function cancel($key = 'x_id')
	{
		$this->setRedirect('index.php');
	}
}
