<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011 Elite-Tec. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Daniel Blum (info@blums.eu)
* @website Visit http://blog.blums.eu for updates and information.
**/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import Joomla! libraries
jimport('joomla.application.component.model');

class EasyImageRotatorCpModelDefault extends JModel {

	private $defailtItemTemplate = array('value' => 0, 'img' => '', 'img_textlayer' => '', 'img_title' => '');
	
	function __construct() {
		parent::__construct();
	}
	
	public function getMenuList()
	{
		/// get menus (properly- ie with indents for submenus!) /// adapted from libraries/joomla/html/html/menu.php
		// get a list of the menu items
		// Create a new query object.
		$db = JFactory::getDBO();
		$query = 'SELECT m.id, m.parent_id, m.title, m.menutype'
					. ' FROM #__menu AS m'
					. ' WHERE m.published = 1'
					. ' ORDER BY m.menutype, m.parent_id, m.ordering';
		$db->setQuery($query);
		$menuResults = $db->loadObjectList();
		//copy items
		$mitems_temp = $menuResults;
	
		// establish the hierarchy of the menu
		$children = array();
		if ($menuResults)
		{
			// first pass - collect children
			foreach ($menuResults as $v)
			{
				$pt	= $v->parent_id;
				$list	= @$children[$pt] ? $children[$pt] : array();
				array_push($list, $v);
				$children[$pt] = $list;
			}
		}
		
		// second pass - get an indent list of the items
		//static treerecurse($id, $indent, $list, &$children, $maxlevel=9999, $level=0, $type=1)
		$list = JHtml::_('menu.treerecurse', intval( $menuResults[0]->parent ), '', array(), $children, 9999, 0, 0);
		
		// Code that adds menu name to Display of Page(s)
		#$mitems_spacer 	= $mitems_temp[0]->menutype;
		
		#echo "<br>Starte Menu";
		$menuItems = array();
		$lastMenuType	= null;
		$tmpMenuType	= null;
		foreach ($list as $list_a) {
			if($list_a->parent_id != 0) {
				if ($list_a->menutype != $lastMenuType) {
					if ($tmpMenuType) {
						#$menuItems[] = JHTML::_('select.option',  '' );
						$menuItems[] = (object) array('value' => '', 'text' => '');
					}
					#$menuItems[] = JHTML::_('select.option',  '', $list_a->menutype );
					$menuItems[] = (object) array('value' => '', 'text' => $list_a->menutype);
					$lastMenuType = $list_a->menutype;
					$tmpMenuType  = $list_a->menutype;
				}
				#$menuItems[] = JHTML::_('select.option',  $list_a->id, $list_a->treename );
				$menuItems[] = (object) array('value' => $list_a->id, 'text' => $list_a->treename);
			}
		}
		//Default fallback
		$menuItems[] = (object) array('value' => 0, 'text' => 'fallback');
		
		if ($lastMenuType !== null) {
			#$menuItems[] = JHTML::_('select.option',  '' );
			$menuItems[] = (object) array('value' => '', 'text' => '');
		}
		
		array_pop($menuItems);

		// now get specified entries!
		$db = JFactory::getDBO();
		$query = "SELECT item_id, img_url, img_textlayer, img_title FROM #__easyimagerotator";
		$db->setQuery($query);
		$tmpResults = $db->loadObjectList();
		 
		//--- put img_urls into the menu items object
		for ($i=0; $i < count($menuItems) ;$i++) {
			foreach ($tmpResults as $item) 
			{
				if ($menuItems[$i]->value == $item->item_id) 
				{
					$menuItems[$i]->img = $item->img_url;
					$menuItems[$i]->img_textlayer = $item->img_textlayer;
					$menuItems[$i]->img_title = $item->img_title;
					break;
				}
			}
		}
		return $menuItems;
	} //getMenuList
	
	public function getDefaultMenuItem($menuItems)
	{
		$defailtItem = $this->defailtItemTemplate;
		foreach($menuItems as $item)
		{
			if($item->value == 0) 
			{
				$defailtItem = $item;
			}
		}
		return (object)$defailtItem;
	}
	
	public function save()
	{
		$mainframe = JFactory::getApplication();
		$task = JRequest::getCmd('task');
	 
	  // insert new rows
		$postedData = JRequest::get('post', JREQUEST_ALLOWRAW);
		
		if(is_array($postedData['menu_id'])) {
			$db =& JFactory::getDBO();
			// delete all rows
			$query = 'DELETE FROM #__easyimagerotator';
			$db->setQuery($query);
			$db->query();
			
			
			foreach($postedData['menu_id'] as $menuId) {
				$menu_url = $postedData['menu_url_'.$menuId];
				$menu_textlayer = $postedData['menu_textlayer_'.$menuId];
				$menu_title = $postedData['menu_title_'.$menuId];
				$query = "INSERT INTO #__easyimagerotator (item_id, img_url, img_textlayer, img_title) VALUES (".$menuId.", '".$menu_url."', '".$menu_textlayer."', '".$menu_title."');";
				#$query_msg .= "<br>".$query;
				$db->setQuery($query);
				$db->query();
			}
		}
		
	  switch ($task)
		{
			case 'savedefault':
				$link = 'index.php';
				break;
			case 'applydefault':
			default:
				$msg  = JText::_('COM_EASYIMAGEROTATOR_SYSTEM_DATASAVEDSUCCESSFULLY');
				$link = 'index.php?option=com_easyimagerotator';
				break;
		}
	  // page redirect
	  $mainframe->redirect($link, $msg);
	  
	} //save
}

?>
