<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011 Elite-Tec. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Daniel Blum (info@blums.eu)
* @website Visit http://blog.blums.eu for updates and information.
**/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class modEasyImageRotatorHelper {
	
	function getMenu() {
		$menu = &JSite::getMenu();
		$active = $menu->getActive();
		return $active->id;
	}
	
	//return image path from menu itemId
	function getImgEntry($menuItemId) 
	{
		$db =& JFactory::getDBO();
		$query = 'SELECT img_url, img_textlayer, img_title FROM #__easyimagerotator WHERE item_id = '.$menuItemId;
		$db->setQuery($query);
		$imgResult = $db->loadObject();
		if(!$imgResult)
		{
			$imgResult = null;
		}
		return $imgResult;  
	}
	
	function getImageData($img_url, $params) 
	{
		$randomFolderName = $params->get('random_folder');
		if ($img_url == '0') 
		{
			return null;
		} 
		else if (JFile::exists(JPATH_BASE.DS.$img_url)) //Get singel image
		{
			return array(JPATH_BASE.DS.$img_url);
		}
		else if ($img_url[strlen($img_url)-1] == '*') //Get random image from a specified folder
		{ 
			// use specified folder to get random pictures from
			$img_path = substr($img_url, 0, -2);
			$images = array();
			if (JFolder::exists(JPATH_BASE.DS.$img_path)) {
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$img_path,'.jpg', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$img_path,'.png', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$img_path,'.gif', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$img_path,'.bmp', true, true));
			}
			
			//shuffle items
			$selectedImages = null;
			$number_of_images = $params->get('number_of_images');
			if(count($images) >= 1)
			{
				if($number_of_images > 1) 
				{
					shuffle($images);
					$selectedImages = array_slice($images, 0, $number_of_images);
				} 
				else 
				{
					$selectedImages = array($images[mt_rand(0, count($images)-1)]);
				}
			}
			return $selectedImages;
		} 
		else // Get random image
		{
			$images = array();
			if (JFolder::exists(JPATH_BASE.DS.$randomFolderName)) {
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$random_folder,'.jpg', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$random_folder,'.png', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$random_folder,'.gif', true, true));
				$images = array_merge($images,JFolder::files(JPATH_BASE.DS.$random_folder,'.bmp', true, true));
			}
			
			//shuffle items
			$selectedImages = null;
			$number_of_images = $params->get('number_of_images');
			if(count($images) >= 1)
			{
				if($number_of_images > 1) 
				{
					shuffle($images);
					$selectedImages = array_slice($images, 0, $number_of_images);
				} 
				else 
				{
					$selectedImages = array($images[mt_rand(0, count($images)-1)]);
				}
			}
			return $selectedImages;
		}
	}
	
	//prepare image by params
	function prepareImage($image, $params) 
	{
		$imgURL = "";
		$imgWidth = 0;
		$imgHeight = 0;
		$imgURL = JURI::Base().substr($image,strlen(JPATH_BASE.DS));
		
		switch ($params->get('fitting')) {
			case '0': //stretch
			if($params->get('width') != "" && $params->get('height') != "") {
					$imgWidth = $params->get('width');
					$imgHeight = $params->get('height');
				}
				break;
			case '1': //fit in
			case '2': //fill
				$img_size = getimagesize($imgURL);
				$img_aspect_ratio = $img_size[1] / $img_size[0];
				$box_aspect_ratio = $params->get('height') / $params->get('width');
				if ( ($params->get('fitting')=='1' && $img_aspect_ratio > $box_aspect_ratio) 
					|| ($params->get('fitting')=='2' && $img_aspect_ratio < $box_aspect_ratio) ){
					$new_height = $params->get('height');
					$new_width = $new_height/$img_aspect_ratio;
				} else {
					$new_width = $params->get('width');
					$new_height = $new_width*$img_aspect_ratio;
				}
				$imgWidth = $new_width;
				$imgHeight = $new_height;
				break;
		}
		//Add values
		$returnValue = array('URL' => $imgURL
								 				,'WIDTH' => $imgWidth
								 				,'HEIGHT' => $imgHeight);
		return $returnValue;
	}
	
	function setUpImages($img, $params) 
	{
		//Get Image form real path
		$arrSelectedImages = modEasyImageRotatorHelper::getImageData($img->img_url, $params);
		#print_r($arrSelectedImages);
		$arrImages = array();
		if(is_array($arrSelectedImages))
		{
			foreach($arrSelectedImages as $img)
			{
				$arrImages[] = modEasyImageRotatorHelper::prepareImage($img, $params);
			}
		}
		return $arrImages;
	}
}

