<?php
/**
* @package EasyImageRotator
* @Copyright (C) 2011 Elite-Tec. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Daniel Blum (info@blums.eu)
* @website Visit http://blog.blums.eu for updates and information.
**/
 
defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.file');

// Include the syndicate functions only once
require_once( dirname(__FILE__).DS.'helper.php' );

if(!JFile::exists(JPATH_SITE.'/administrator/components/com_easyimagerotator/easyimagerotator.php')) {
	echo JText::_('This module is nothing without the Easy Image Rotator component!<br><br><strong> Please install this component!</strong>');
	return;
}

$arrImages = null;
$active_menuItemId = modEasyImageRotatorHelper::getMenu();
$objImgResult = modEasyImageRotatorHelper::getImgEntry($active_menuItemId);

//If fallback for image directory has been set
if($params->get("use_fallback") == "1" && $objImgResult == null)
{
	$objImgResult  = modEasyImageRotatorHelper::getImgEntry(0);
	//DEBUG
	//echo "<br/>Fallback URL-Result:".$objImgResult->img_url;
	$arrImages 		 = modEasyImageRotatorHelper::setUpImages($objImgResult, $params);
}
else
{
	$arrImages = modEasyImageRotatorHelper::setUpImages($objImgResult, $params);
}
//DEBUG
//echo "<br/>URL-Result:".$objImgResult->img_url;

/**
show_as_js_gallery = 1 display as js gallery
show_as_js_gallery = 1 display as normal image
**/
if($params->get("show_as_js_gallery") == "2") 
{
	if(is_array($arrImages)) 
	{
		echo '<div style="height:'.$arrImages[0]['HEIGHT'].'px;width:'.$arrImages[0]['WIDTH'].'px;overflow:hidden">
						<img src="'.$arrImages[0]['URL'].'" height="'.$arrImages[0]['HEIGHT'].'" alt="'.$imgResult->img_title.'" title="'.$imgResult->img_title.'" width="'.$arrImages[0]['WIDTH'].'" />
					</div>';
	}
} 
else 
{
	$img_textlayer = "";
	$showInfopane = "false";
	if($params->get("text_layer") == "1") 
	{
		$img_textlayer = $imgResult->img_textlayer;
		if(trim($img_textlayer) != "") 
		{
			$showInfopane = "true";
		}
	}
?>
	<link rel="stylesheet" href="/modules/mod_easyimagerotator/css/jd.gallery.css" type="text/css" media="screen" charset="utf-8" />
	<script src="/modules/mod_easyimagerotator/js/jd.gallery.js" type="text/javascript"></script>
	<script src="/modules/mod_easyimagerotator/js/jd.gallery.transitions.js" type="text/javascript"></script>
	<script type="text/javascript">
		function startGallery() {
			var myGallery = new gallery($('myGallery'), {
				timed: true,
				delay: 8000, 
				showArrows: true,
				showCarousel: false,
				embedLinks: false,
				showInfopane: <?php echo $showInfopane; ?>
			});
		}
		window.addEvent('domready',startGallery);
	</script>
	
	<?php
	echo '<style type="text/css">
					#myGallery {
						width:'.$params->get("width").'px;
						height:'.$params->get("height").'px;
					}
				</style>';

	 if(is_array($arrImages)) 
	 {
		echo '<div id="myGallery">';
	 	foreach($arrImages as $imgItem) 
	 	{
	 		echo '<div class="imageElement">
							<h3>'.$img_textlayer.'</h3>
							<p></p>
							<a href="#" title="" class="open"></a>
							<img src="'.$imgItem['URL'].'" width="'.$imgItem['WIDTH'].'" height="'.$imgItem['HEIGHT'].'" class="full" />
						</div>';
	 	}
	 	echo '</div>';
	 }

} //End show_as_js_gallery select
?>