<?php
/**
 * Standard gallery theme
 * @package Themes
 * @subpackage MatrixLightbox
 * @author Ghetto-Coder <badgott@gmx.de>
 * @version $Revision: 18172 $
 */
class MatrixLightboxTheme extends GalleryTheme {

    function MatrixLightboxTheme() {
	global $gallery;

	$this->setId('matrixlightbox');
	$this->setName($gallery->i18n('Matrixlightbox'));
	$this->setDescription($gallery->i18n('Standard Gallery2 look and feel'));
	$this->setVersion('1.0.0');
	$this->setRequiredCoreApi(array(7, 20));
	$this->setRequiredThemeApi(array(2, 4));
	$this->setStandardSettings(
	    array('rows' => 3, 'columns' => 3,
		  'showImageOwner' => 0, 'showAlbumOwner' => 1,
		  'albumFrame' => '', 'itemFrame' => '', 'photoFrame' => '',
		  'colorpack' => '', 'showMicroThumbs' => 0, 'dynamicLinks' => 'browse',
		  'sidebarBlocks' => serialize(array(
			array('search.SearchBlock', array('showAdvancedLink' => true)),
			array('core.ItemLinks', array('useDropdown' => false)),
			array('core.PeerList', array()),
			array('imageblock.ImageBlock', array()))),
		  'albumBlocks' => serialize(array(
			array('comment.ViewComments', array()))),
		  'photoBlocks' => serialize(array(
			array('exif.ExifInfo', array()),
			array('comment.ViewComments', array())))));
    }

    /**
     * @see GalleryTheme::showAlbumPage
     */
    function showAlbumPage(&$template, $item, $params, $childIds) 
    {
			$ret = $this->loadCommonTemplateData(
			    $template, $item, $params,
			    array('owner', 'viewCount', 'childCount', 'descendentCount', 'parents',
				  'systemLinks', 'itemLinks', 'itemSummaries', 'permissions',
				  'thumbnails', 'pageNavigator', 'jumpRange'),
			     $childIds);
			if ($ret) {
			    return array($ret, null);
			}
		
			/* Add in our extra stuff */
			$theme =& $template->getVariableByReference('theme');
			$theme['columnWidthPct'] = floor(100 / $params['columns']);
		
		/** Lightbox zusatz Start **/
		 foreach ($childIds as $childId)
		 {
          list ($ret, $resizeTable) = GalleryCoreApi::fetchResizesByItemIds(array($childId));
          if (isset($resizeTable[$childId][0])) 
          {
            $theme['resizeId'][$childId] = $resizeTable[$childId][0]->getId();
          }
     }
     
     foreach ($theme['children'] as $id=>$item)
     {
          if ($item['descendentCount'] >0 )
          {
            list ($ret, $Descendent) = GalleryCoreApi::fetchItemizedDescendentCounts(array($item['id']));
            $theme['children'][$id]['Descendent'] = $Descendent[$item['id']];
          }
    	}
    	/** Lightbox zusatz END **/

			/* Add our header and styles */
			return array(null, 'theme.tpl');
    }

    /**
     * @see GalleryTheme::showPhotoPage
     */
    function showPhotoPage(&$template, $item, $params) {
	$dataTypes = array('owner', 'parents', 'systemLinks', 'itemLinks', 'permissions',
			   'itemLinksDetailed', 'itemNavigator', 'imageViews');
	if (!empty($params['showMicroThumbs'])) {
	    $dataTypes[] = 'navThumbnails';
	}
	$ret = $this->loadCommonTemplateData($template, $item, $params, $dataTypes);
	if ($ret) {
	    return array($ret, null);
	}

	return array(null, 'theme.tpl');
    }

    /**
     * @see GalleryTheme::showModulePage
     */
    function showModulePage(&$template, $item, $params, $templateFile) {
	$ret = $this->loadCommonTemplateData(
	    $template, $item, $params, array('parents', 'systemLinks'));
	if ($ret) {
	    return array($ret, null);
	}

	return array(null, 'theme.tpl');
    }

    /**
     * @see GalleryTheme::showAdminPage
     */
    function showAdminPage(&$template, $item, $params, $templateFile) {
	$ret = $this->loadCommonTemplateData(
	    $template, $item, $params, array('parents', 'systemLinks'));
	if ($ret) {
	    return array($ret, null);
	}

	return array(null, 'theme.tpl');
    }

    /**
     * @see GalleryTheme::showErrorPage
     */
    function showErrorPage(&$template) {
	return array(null, 'error.tpl');
    }

    /**
     * @see GalleryTheme::showProgressBarPage
     */
    function showProgressBarPage(&$template, $item, $params) {
	$ret = $this->loadCommonTemplateData(
	    $template, $item, $params, array('parents', 'systemLinks'));
	if ($ret) {
	    return array($ret, null);
	}

	return array(null, 'theme.tpl');
    }
}
?>
