<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Site\Model;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ItemModel;
use CodeNinja\Component\EasyGCalendar\Administrator\Model\FormatHelper;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\Utils;

//require_once(JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utilsBase.php');
//JLoader::register('EasyGCalendarHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utils.php');
//JLoader::register('EasyGCalendarGoogleAPIHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/googleAPI.php');

class EventModel extends ItemModel
{
	/** @var object parameters item */
	protected $params;
	/** @var object event item */
	protected $event;
	/** @var string reference type (com | mod | mod_upcomming) */
	protected $refType;
	/** @var int reference ID */
	protected $refID;
	
	  /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since   1.6
     *
     * @return void
     */
    protected function populateState()
    {
		$app = Factory::getApplication();
		// Load the parameters.
		$params = $app->getParams();	

		//Check for Menu Item parameters (component only)
		if(is_numeric($this->refID) && $this->refID > 0)
		{
			switch(strtolower($this->refType))
			{
				case 'com': //Component
					$tmpMenuItem = $app->getMenu()->getItem((int)$this->refID);
					if($tmpMenuItem)
					{
						// Merge global params with item params
						$tmpParams = clone $tmpMenuItem->getParams();
						$params->merge($tmpParams);
					}
				break;
				
				case 'mod': //Modules
					$moduleParams = Utils::getModuleParameterByID((int)$this->refID);
					if($moduleParams)
					{
						// Merge global params with item params
						$tmpParams = clone $moduleParams;
						$params->merge($tmpParams);
					}
				break;
			}
			//echo "<br>DEBUG:Merged Params[event_show_url]->[".$params->get('event_show_url')."]";
		}
		
		$this->setState('params', $params);
		parent::populateState();
	}

	 /**
     * Method to get event data.
     *
     * @param   integer  $pk  The id of the event.
     *
     * @return  object|boolean  Event item data object on success, boolean false
     */
	public function getItem($pk = null)
    {
		$app = Factory::getApplication();
		if($this->event == null)
		{
			// Load the Event-Data.
			$calendarID = $app->input->get('calendarId');
			$eventID 	= $app->input->get('eventId');
			//echo "<br/>DUBUG: Calendar->".$calendarID." Event->".$eventID;
			
			$this->event = Utils::getEventData($calendarID, $eventID);
			if($this->event == null) 
			{
				throw new \Exception(Text::_('COM_EASYGCALENDAR_EVENT_ERROR_EVENT_NOT_FOUND'), 403);
				return null;
				
			}
			
			$this->setState('event', $this->event );
		}
		
		return $this->event;
	}
	
	/** Get the parameters of the component (merged)
	 * @return object with the available parameters of the component.  */
	public function getParams()
	{
		$app = Factory::getApplication();
		$this->refType 			= $app->input->get('refType');
		$this->refID 			= $app->input->get('refID');
		
		if($this->params == null)
		{
			$this->params = $this->getState('params');
		}
		return $this->params;
	}
		
	/** Get the selected event
	 * @return object  */
	public function getEvent()
	{
		$app = Factory::getApplication();
		if($this->event == null)
		{
			// Load the Event-Data.
			$calendarID = $app->input->get('calendarId');
			$eventID 	= $app->input->get('eventId');
			//echo "<br/>DUBUG: Calendar->".$calendarID." Event->".$eventID;
			
			$this->event = Utils::getEventData($calendarID, $eventID);
			if($this->event == null) 
			{
				throw new \Exception(Text::_('COM_EASYGCALENDAR_EVENT_ERROR_EVENT_NOT_FOUND'), 403);
				return null;
				
			}
			
			$this->setState('event', $this->event );
		}
		
		return $this->event;
	}
}
?>