<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2018 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\View\Calendar;


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;

//JLoader::register('EasyGCalendarHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utils.php');

class HtmlView extends BaseHtmlView
{
	protected $form;
	protected $item;
	protected $state;
	
	/**
	 * Execute and display a template script.
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 * @return  mixed  A string if successful, otherwise a Error object.
	*/
	function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->canDo	= ContentHelper::getActions(UtilsBaseClass::$extensionName, 'calendar', (!empty($this->item->item_id)) ? $this->item->item_id : 0);
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new GenericDataException(implode("\n", $errors), 500);
			return false;
		}
		
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	*/
	protected function addToolbar()
	{
		Factory::getApplication()->input->set('hidemainmenu', true);
		$isNew		= ($this->item->id == 0);
		
		// Built the actions for new and existing records.
		$canDo		= $this->canDo;
		
		ToolBarHelper::title(Text::_('COM_EASYGCALENDAR_MANAGER_CALENDAR'), 'calendar');
		
		// For new records, check the create permission.
		if ($isNew && $canDo->get('core.create'))
		{
			ToolbarHelper::apply('calendar.apply');
			ToolbarHelper::save('calendar.save');
			ToolbarHelper::save2new('calendar.save2new');
			ToolbarHelper::cancel('calendar.cancel');
		}
		else
		{
			if ($canDo->get('core.edit'))
			{
				ToolbarHelper::apply('calendar.apply');
				ToolbarHelper::save('calendar.save');

				// We can save this record, but check the create permission to see if we can return to make a new one.
				if ($canDo->get('core.create'))
				{
					ToolbarHelper::save2new('calendar.save2new');
				}
			}
			
			// If checked out, we can still save
			if ($canDo->get('core.create'))
			{
				ToolbarHelper::save2copy('calendar.save2copy');
			}
			ToolbarHelper::cancel('calendar.cancel', 'JTOOLBAR_CLOSE');
		}	
	}
}
?>