<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\HtmlHelper as EasyGCalendarHtmlHelper;

/** @var CodeNinja\Component\EasyGCalendar\Administrator\View\Calendars\HtmlView $this */

$wa = $this->document->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect');
	
?>
<form action="<?php echo Route::_('index.php?option='.UtilsBaseClass::$extensionName); ?>" method="POST" id="adminForm" name="adminForm">
	<table class="table table-striped" id="calendarList">
		<thead>
			<tr>
				<th width="5"><?php echo Text::_( 'COM_EASYGCALENDAR_FIELD_NAME_ID_LABEL' ); ?></th>
				<th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $this->items ); ?>);" /></th>
				<th><?php echo Text::_( 'COM_EASYGCALENDAR_FIELD_NAME_LABEL' ); ?></th>
				<th><?php echo Text::_( 'COM_EASYGCALENDAR_FIELD_COLOR_LABEL' ); ?></th>
				<th><?php echo Text::_( 'COM_EASYGCALENDAR_FIELD_CALENDAR_ID_LABEL' ); ?></th>
				<th><?php echo Text::_( 'COM_EASYGCALENDAR_FIELD_APIKEY_LABEL' ); ?></th>
			</tr>
		</thead>
		<tbody><?php echo $this->loadTemplate('body');?></tbody>
		<tfoot>
			<tr>
				<td colspan="6">
					<?php echo $this->pagination->getListFooter(); ?>
					<br/><br/>
					<div align="center" style="clear: both">
						<?php echo sprintf(Text::_('COM_EASYGCALENDAR_FOOTER'), EasyGCalendarHtmlHelper::getVersionTag(true));?>
					</div>
				</td>
			</tr>
		</tfoot>
	</table>
	<div>
		<input type="hidden" name="option" value="com_easygcalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<?php echo HTMLHelper::_('form.token'); ?>
	</div>
</form>
	