<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\Model;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\AdminModel;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;

//require_once(JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utilsBase.php');
//JLoader::register('EasyGCalendarHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utils.php');

/**
 * Item Model for an Calendar.
 */
class CalendarModel extends AdminModel
{
	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param   string  $type    The table type to instantiate
	 * @param   string  $prefix  A prefix for the table class name. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JTable    A database object
	 */
	//public function getTable($type = 'Calendar', $prefix = 'EasyGCalendarTable', $config = array())
	//{
	//	return Table::getInstance($type, $prefix, $config);
	//}
	
	/**
	* Method to get the record form.
	*
	* @param   array    $data      Data for the form.
	* @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	*
	* @return  mixed  A JForm object on success, false on failure
	*/
	public function getForm($data = array(), $loadData = true) 
	{
		// Get the form.
		$form = $this->loadForm(UtilsBaseClass::$extensionName.'.calendar', 'calendar', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form)) 
		{
			return false;
		}
		return $form;
	}
	
	/**
	* Method to get the data that should be injected in the form.
	*
	* @return  mixed  The data for the form.
	*/
	protected function loadFormData() 
	{
		// Check the session for previously entered form data.
		$app = Factory::getApplication();
        $data = $app->getUserState(UtilsBaseClass::$extensionName.'.edit.calendar.edit.' . $this->getName() . '.data', []);
		//$data = Factory::getApplication()->getUserState(UtilsBaseClass::$extensionName.'.edit.calendar.data', []);
		
		if (empty($data)) 
		{
			$data = $this->getItem();
		}
		return $data;
	}
}
?>
