<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\HtmlHelper as EasyGCalendarHtmlHelper;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive');
$wa->useScript('form.validate');

$app = Factory::getApplication();
$input = $app->input;

?>
<form action="<?php echo Route::_('index.php?option='.UtilsBaseClass::$extensionName.'&layout=edit&id='.(int) $this->item->id); ?>" method="POST" name="adminForm" id="adminForm" class="form-validate">
	
	<div class="form-horizontal">
		<?php echo $this->form->renderFieldset('details'); ?>
		<input type="hidden" name="task" value="calendar.edit" />
		<input type="hidden" name="return" value="<?php echo $input->getCmd('return'); ?>" />
		<?php echo HTMLHelper::_('form.token'); ?>
	</div>
</form>

<div align="center" style="clear: both">
	<?php echo sprintf(Text::_('COM_EASYGCALENDAR_FOOTER'), EasyGCalendarHtmlHelper::getVersionTag(true));?>
</div>