<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\View\Calendars;

// No direct access to this file
//defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
//use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use CodeNinja\Component\EasyGCalendar\Administrator\Model\ModelCalendars;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;
//use JLoader;

//JLoader::register('EasyGCalendarHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utils.php');
//JLoader::registerAlias('EasyGCalendarHelperBase', 'CodeNinja\Component\EasyGCalendar\Administrator\Helpers\EasyGCalendarHelperBase');

class HtmlView extends BaseHtmlView 
{
	  /**
     * An array of items
     *
     * @var  array
     */
	protected $items;

	/**
     * The pagination object
     *
     * @var  \Joomla\CMS\Pagination\Pagination
     */
	protected $pagination;
	 /**
     * The model state
     *
     * @var  \Joomla\CMS\Object\CMSObject
     */
	protected $state;

	public $filterForm;
	public $activeFilters;

	/**
     * Is this view an Empty State
     *
     * @var   boolean
     *
     * @since 4.0.0
     */
    private $isEmptyState = false;
	
	/**
	 * Method to display the view.
	 * @return void
	 **/
	public function display($tpl = null): void
    {
        /** @var ModelCalendars $model */
        $model               = $this->getModel();
        //$this->categories    = $model->getCategoryOrders();
        $this->items         = $model->getItems();
        $this->pagination    = $model->getPagination();
        $this->state         = $model->getState();
        $this->filterForm    = $model->getFilterForm();
        $this->activeFilters = $model->getActiveFilters();

		if (!\count($this->items) && $this->isEmptyState = $this->get('IsEmptyState')) {
            $this->setLayout('emptystate');
        }

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new GenericDataException(implode("\n", $errors), 500);
			//return false;
		}
		
		$this->addToolbar();

		 // We do not need to filter by language when multilingual is disabled
		 //if (!Multilanguage::isEnabled()) {
         //   unset($this->activeFilters['language']);
         //   $this->filterForm->removeField('language', 'filter');
        //}

		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	*/
	protected function addToolbar()
	{
		// Built the actions for new and existing records.
		$canDo = ContentHelper::getActions(UtilsBaseClass::$extensionName, 'calendar', $this->state->get('filter.id'));
		$user  = Factory::getApplication()->getIdentity();
		
		ToolbarHelper::title(Text::_('COM_EASYGCALENDAR_MANAGER_CALENDAR'), 'calendar');
		
		if ($canDo->get('core.create'))
		{
			ToolbarHelper::addNew('calendar.add', 'JTOOLBAR_NEW');
		}
		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::editList('calendar.edit');
		}
		if ($canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('', 'calendars.delete', 'JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences(UtilsBaseClass::$extensionName, 550);
			ToolbarHelper::divider();
		}
	}
}
?>