<?php

/**
 * @package EasyGCalendar
 * @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
 * @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author Daniel Blum
 * @website Visit https://codeninja.eu for updates and information.
 **/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsBaseClass;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\Utils;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\FormatHelper;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\HtmlHelper as EasyGCalendarHtmlHelper;

HTMLHelper::_('bootstrap.framework');
HTMLHelper::_('jquery.framework');

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->registerAndUseStyle(UtilsBaseClass::$extensionName. 'calendar', 'components/' . UtilsBaseClass::$extensionName . '/tmpl/calendar/calendar.css');
$wa->registerAndUseStyle(UtilsBaseClass::$extensionName. 'fullcalendar-core', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/core/main.css');
$wa->registerAndUseStyle(UtilsBaseClass::$extensionName. 'fullcalendar-daygrid', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/daygrid/main.css');
$wa->registerAndUseStyle(UtilsBaseClass::$extensionName. 'fullcalendar-timegrid', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/timegrid/main.css');
$wa->registerAndUseStyle(UtilsBaseClass::$extensionName. 'fullcalendar-list', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/list/main.css');

$wa->registerAndUseScript('fullcalendar-locales', 'components/' . UtilsBaseClass::$extensionName . '/libraries/moment-with-locales.min.js');
$wa->registerAndUseScript('fullcalendar-main', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/core/main.js');
$wa->registerAndUseScript('fullcalendar-moment', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/moment/main.min.js');
$wa->registerAndUseScript('fullcalendar-interaction', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/interaction/main.js');
$wa->registerAndUseScript('fullcalendar-daygrid', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/daygrid/main.js');
$wa->registerAndUseScript('fullcalendar-timegrid', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/timegrid/main.js');
$wa->registerAndUseScript('fullcalendar-list', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/list/main.js');
$wa->registerAndUseScript('fullcalendar-core', 'components/' . UtilsBaseClass::$extensionName . '/libraries/fullcalendar-4/packages/core/locales-all.min.js');

$wa->registerAndUseScript(UtilsBaseClass::$extensionName .'_popper', 'components/' . UtilsBaseClass::$extensionName . '/libraries/popper.min.js');
$wa->registerAndUseScript(UtilsBaseClass::$extensionName .'_tippy-bundle', 'components/' . UtilsBaseClass::$extensionName . '/libraries/tippy-bundle.umd.min.js');
$wa->registerAndUseScript(UtilsBaseClass::$extensionName .'_calendarjs', 'components/' . UtilsBaseClass::$extensionName . '/tmpl/calendar/calendar.js');

//Parameter Setup for this View
//Calendar
$paramCalendarIDs 							=  $this->params->get('calendarids');
$paramCalendarDefaultView 					=  $this->params->get('defaultView', 'month');
$paramCalendarShowFilters					= ($this->params->get('display_calendar_filters', 0) ? true : false);
$paramCalendarWeekStart						= intval($this->params->get('weekstart', 1));
$paramCalendarShowWeekNumbers				= ($this->params->get('weeknumbers', 1) ? true : false);
$paramCalendarShowWeekend					= ($this->params->get('weekend', 1) ? true : false);
$paramCalendarEnableCalendarListViewMonth	= ($this->params->get('enableCalendarListViewMonth', 0) ? true : false);
//Calendar Column Formats
$paramCalendarColumnFormatMonth			 	= $this->params->get('columnformat_month'); //D
$paramCalendarColumnFormatWeek			 	= $this->params->get('columnformat_week'); //D n/j
$paramCalendarColumnFormatDay				= $this->params->get('columnformat_day'); //l
$paramCalendarColumnFormatList			 	= $this->params->get('columnformat_list'); //D
//Calendar View Formats
//Month Formats
$paramCalendarTitleFormatMonth			 	= $this->params->get('titleformat_month', 'F Y'); //MMMM YYYY
$paramCalendarTimeFormatMonth				= $this->params->get('timeformat_month', 'g:i a');
//Week Formats
$paramCalendarTitleFormatWeek				= $this->params->get('titleformat_week', 'F d, Y'); //MMMM DD, YYYYD
$paramCalendarTimeFormatWeek				= $this->params->get('timeformat_week', 'g:i a');
//Day Formats
$paramCalendarTitleFormatDay				= $this->params->get('titleformat_day', 'F Y, d'); //MMMM DD, YYYY
$paramCalendarTimeFormatDay					= $this->params->get('timeformat_day', 'g:i a');
$paramCalendarAxisFormat					= $this->params->get('slotlabelformat', 'H'); //HH 24 hour time
//Time
$paramCalendarMinTime						= $this->params->get('min_time', '00:00:00');
$paramCalendarMaxTime						= $this->params->get('max_time', '24:00:00');
//Popup
$paramCalendarShowEventInPopup			 	= ($this->params->get('open_event_in_popup', 1) == 1 ? true : false);
$paramCalendarEventPopupWidth				= $this->params->get('popup_width', 700);
$paramCalendarEventPopupHeigth			 	= $this->params->get('popup_height', 500);
//Tooltip
$paramCalendarShowTooltip					= ($this->params->get('display_tooltip_info', 1) ? true : false);
$paramCalendarTooltipDateFormat			 	= $this->params->get('tooltip_date_format', 'm.d.Y');
$paramCalendarTooltipTimeFormat			 	= $this->params->get('tooltip_time_format', 'g:i a');
$paramCalendarTooltipDescriptionLen	 		= $this->params->get('tooltip_description_length', 0);
//Content
$paramCalendarContentHeight					= $this->params->get('calendar_height', null);
$paramCalendarTextBefore					= $this->params->get('textbefore');
$paramCalendarTextAfter						= $this->params->get('textafter');
//Themes & Style
$paramCalendarTooltipTheme					= $this->params->get('qtip_theme', '');
//Caching
$paramCacheType 							=  $this->params->get('cache_type', 0);
$paramCacheTimeInMinutes					= ((int) $this->params->get('cache_time', Factory::getApplication()->get('cachetime')) * 60); //The cachetime in minutes
//Frontend Framework
$paramModuleClass_sfx 						= htmlspecialchars($this->params->get('moduleclass_sfx') ?? '');
$paramFrontendFramework 					= $this->params->get('frontend_framework', UtilsBaseClass::$frontendFrameworkBS5);


//Prepare Modal
$modalWidth = is_numeric($paramCalendarEventPopupWidth) ? 'width:' . $paramCalendarEventPopupWidth . 'px;' : '';
$modalHeight = is_numeric($paramCalendarEventPopupHeigth) ? 'height:' . $paramCalendarEventPopupHeigth . 'px;' : '';
$modalBodyHeight = is_numeric($paramCalendarEventPopupHeigth) ? 'height:' . ((int)$paramCalendarEventPopupHeigth - 50) . 'px;' : '';

//Prepare calendars
$arrCalendarIDs = array();
if (is_array($paramCalendarIDs)) {
	$arrCalendarIDs = $paramCalendarIDs;
} else if (!empty($paramCalendarIDs)) {
	$arrCalendarIDs = $paramCalendarIDs;
}

//Define default view of calendar
$defaultView = 'dayGridMonth';
if ($paramCalendarDefaultView == 'week') {
	$defaultView = 'timeGridWeek';
} else if ($paramCalendarDefaultView == 'day') {
	$defaultView = 'timeGridDay';
}

$languageLocal = FormatHelper::getLanguageLocale();

//Prepare Calendar config
$arrCalendarConfig = array();

//General Display
$arrCalendarConfig['header'] = array('left' => 'prev,next,today', 'center' => 'title', 'right' => 'dayGridMonth,timeGridWeek,timeGridDay'. ($paramCalendarEnableCalendarListViewMonth ? ',listMonth' : ''));
//$arrCalendarConfig['defaultDate'] = ''; //set current Date from client-side (this is automatcally done if the param is not set)
$arrCalendarConfig['locale'] = $languageLocal; //this setting is used for fullcalendar and moment.js so ensure both locales are available.
$arrCalendarConfig['defaultView'] = $defaultView;
$arrCalendarConfig['editable'] = false;
//Set contentHeight if required
if (!empty($paramCalendarContentHeight)) {
	$arrCalendarConfig['contentHeight'] =  $paramCalendarContentHeight;
}
$arrCalendarConfig['weekends'] = $paramCalendarShowWeekend;
$arrCalendarConfig['navLinks'] = true;  // can click day/week names to navigate views
$arrCalendarConfig['eventLimit'] = true;  // allow "more" link when too many events
$arrCalendarConfig['firstDay'] = $paramCalendarWeekStart; //Sunday=0, Monday=1, Tuesday=2, etc.
$arrCalendarConfig['weekNumbers'] = $paramCalendarShowWeekNumbers;
$arrCalendarConfig['timeZone'] = 'local';

//Text & Time Customization
$arrCalendarConfig['weekLabel'] = Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_WEEK_NUMBER_TITLE');
$arrCalendarConfig['buttonText'] = array(
	'today' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_TOOLBAR_TODAY'),
	'month' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_VIEW_MONTH'),
	'week' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_VIEW_WEEK'),
	'day' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_VIEW_DAY'),
	'list' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_VIEW_LIST')
);
$arrCalendarConfig['eventLimitText'] = Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_EVENT_LIMIT_TEXT');

//Emphasizes certain time slots on the calendar. By default, Monday-Friday, 9am-5pm.
$arrCalendarConfig['businessHours'] = array('startTime' => '10:00', 'endTime' => '18:00');

//Configuration of Columns & Views
//View-Specific Options (https://fullcalendar.io/docs/view-specific-options)

$arrCalendarConfig['views']['month'] = array(
	'columnHeaderFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatMonth), // Mon, Wed, etc.
	'titleFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarTitleFormatMonth), //MMMM YYYY
	'eventTimeFormat' =>  FormatHelper::convertToFullcalendarFormat($paramCalendarTimeFormatMonth)
);

$arrCalendarConfig['views']['week'] = array(
	'columnHeaderFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatWeek), // Mon 9/7
	'titleFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarTitleFormatWeek), //MMMM DD, YYYY
	'eventTimeFormat' =>  FormatHelper::convertToFullcalendarFormat($paramCalendarTimeFormatWeek),
	'locale' => 'fr'
);

$arrCalendarConfig['views']['day'] = array(
	'columnHeaderFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatDay), // Monday
	'titleFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarTitleFormatDay), //MMMM DD, YYYY
	'eventTimeFormat' =>  'HH:mm:ss'
);

$arrCalendarConfig['views']['list'] = array(
	'columnHeaderFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatList), //  Mon, Wed, etc.
	'listDayFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatList),
	//'listDayAltFormat' => ''
);

$arrCalendarConfig['views']['timeGrid'] = array(
	'columnHeaderFormat' => FormatHelper::convertToFullcalendarFormat($paramCalendarColumnFormatList), //  Mon, Wed, etc
	//Agenda view options
	'minTime' => $paramCalendarMinTime, //00:00:00
	'maxTime' => $paramCalendarMaxTime, //24:00:00
	//'slotDuration' => '',
	'slotLabelFormat' => $paramCalendarAxisFormat,
	// 'allDaySlot' => true, //default is true
	'allDayText' => Text::_('COM_EASYGCALENDAR_CALENDAR_VIEW_ALL_DAY')
);

//Prepare IDs
//$menu = Factory::getApplication()->getMenu(); 
//$active = $menu->getActive(); 
//$itemId = $active->id;
$intRefID = Factory::getApplication()->getMenu()->getActive()->id; //for more possible options of manipulation check https://docs.joomla.org/Supporting_SEF_URLs_in_your_component
if ($intRefID <= 0) {
	Factory::getApplication()->enqueueMessage('Component ID is missing this will lead to an invalid calendar view!', 'error');
}
$strUniqueID = $intRefID;
$strEasygCalendarIdentifier = "easygcalendar_component-" . $strUniqueID;

//Prepare calendar settings
$arrCalendarResults = Utils::getCalendarList($arrCalendarIDs);
print EasyGCalendarHtmlHelper::getVersionTag();
if (is_array($arrCalendarResults)) {
	$arrCalendarConfig['eventSources'][] = Utils::getCalendarDataUrl(array(), 'com', $intRefID);
	$strCalendarFilterHtml = Utils::getCalendarFilter($arrCalendarResults, $strEasygCalendarIdentifier);
}
?>

<div class="calendar-page <?php echo $paramModuleClass_sfx; ?>">
	<?php echo $paramCalendarTextBefore; ?>
	<div id='<?php echo $strEasygCalendarIdentifier; ?>'></div>
	<?php echo $paramCalendarTextAfter; ?>
</div>
<script type="text/javascript">
	const easyGCalendarJS = new EasyGCalendarManagement();
	easyGCalendarJS.setEventSources('<?php echo $strEasygCalendarIdentifier ?>', '<?php echo json_encode($arrCalendarConfig['eventSources']); ?>');

	document.addEventListener('DOMContentLoaded', function() {
		var calendarEl = document.getElementById('<?php echo $strEasygCalendarIdentifier; ?>');

		var options = {
			plugins: ['moment', 'interaction', 'dayGrid', 'timeGrid', 'list'],
			eventClick: function(info) {
				info.jsEvent.preventDefault(); // don't let the browser navigate

				<?php if ($paramCalendarShowEventInPopup) { ?>
					easyGCalendarJS.openModal('event-details-view-<?php echo $strUniqueID; ?>', info.event.extendedProps.details_url, info.event.title, '<?php echo strtoupper($paramFrontendFramework); ?>');
				<?php } else { ?>
					window.location = info.event.extendedProps.details_url.replace(/&amp;/g, '&');
				<?php } ?>
			},
			eventRender: function(info) {
				<?php if ($paramCalendarShowTooltip) { ?>
					var eventDesc = info.event.extendedProps.description;

					<?php if ($paramCalendarTooltipDescriptionLen > 0) { ?>
						if (eventDesc != null && eventDesc.length > 10) eventDesc = eventDesc.substring(0, <?php echo $paramCalendarTooltipDescriptionLen; ?>);
					<?php } ?>

					var tmpStart = moment(info.event.start).format('<?php echo FormatHelper::convertToFullcalendarFormat($paramCalendarTooltipTimeFormat); ?>');
					var tmpEnd = moment(info.event.end).format('<?php echo FormatHelper::convertToFullcalendarFormat($paramCalendarTooltipTimeFormat); ?>');
					var tooltip = tippy(info.el, {
						content: '<div>' + tmpStart + ' - ' + tmpEnd + ' ' + info.event.title + ' </div>' + (eventDesc != null ? '<hr />' + eventDesc : ''),
						allowHTML: true,
						theme: '<?php echo $paramCalendarTooltipTheme; ?>',
					});
				<?php } ?>
			},
			loading: function(bool) {
				//document.getElementById('loading').style.display = bool ? 'block' : 'none';
			}
		};

		jQuery.extend(true, options, <?php echo json_encode($arrCalendarConfig); ?>);
		var calendar = new FullCalendar.Calendar(calendarEl, options);
		calendar.render();

	});
</script>

<!-- Bootstrap Modal -->
<?php if ($paramCalendarShowEventInPopup) {
	echo EasyGCalendarHtmlHelper::getModalContent($strUniqueID, $paramFrontendFramework, $modalWidth, $modalHeight, $modalBodyHeight);
} ?>