
//const easyGCalendarJS = EasyGCalendarManagement.getInstance();

class EasyGCalendarManagement {
	EventSources = [];
	
	/**
	// constructor
	**/
	constructor() {
		if (!!EasyGCalendarManagement.instance) {
			return EasyGCalendarManagement.instance;
		}
	
		EasyGCalendarManagement.instance = this;
	
		return this;
	}

	/**
	// Set the event sources json array
	**/
	setEventSources(id, sources)
	{
		this.EventSources[id] = sources;
	}
	
	/**
	// Open Bootstrap Modal
	**/
	openModal(modalID, modalUrl, modalTitle, frontendFramework)
	{
		var modalSelector = '#' + modalID;
		var onModalDisplayEvent = 'shown.bs.modal';
		var onModalHideEvent = 'hidden.bs.modal';

		/**if(frontendFramework.toUpperCase() == 'BS5') {
			onModalDisplayEvent = 'shown.bs.modal';
			onModalHideEvent = 'hidden.bs.modal';
		}**/
		
		//Attach Bootstrap Modal Events
		jQuery(modalSelector).on(onModalDisplayEvent, function() {
			var url = modalUrl + '&isModal=1&tmpl=component';
			jQuery(modalSelector + ' .modal-title').text( modalTitle );
			jQuery(modalSelector + ' iframe').attr('src', url );
		});
		
		jQuery(modalSelector).on(onModalHideEvent, function() {
			jQuery(modalSelector + ' iframe').removeAttr('src');
		});
		
		var modal = jQuery(modalSelector).modal('show');
	}
	
	/**
	// Print the selected element
	**/
	printElement(element)
	{
		var tmpWindow = window.open('Print');
		tmpWindow.document.write ('<html><head>' + 
									'<link rel="stylesheet" href="' + window.globalTemplate + '" type="text/css" />' +
									'<link rel="stylesheet" href="/components/com_easygcalendar/views/event/tmpl/event.css" type="text/css" />' +
									'</head><body></body></html>');
		tmpWindow.document.body.innerHTML += document.getElementById(element).innerHTML;
		tmpWindow.document.close(); // necessary for IE >= 10
		tmpWindow.focus(); // necessary for IE >= 10*/
		tmpWindow.onload = function () { 
			tmpWindow.document.title='print';
			tmpWindow.print();
			tmpWindow.close();
		}
		return true;
	}
	
	/**
	// Print the selected element
	**/
	getICalDownload(element)
	{
		var url = jQuery(element).attr("data-ical");
		console.log(url);
		window.location = url;
		return true;
	}
	
	/**
	// Applay the selected calendar filter
	**/
	applyCalendarFilter(element)
	{
		var selectedValue = jQuery(element).val();
		var fullcalendarID = jQuery(element).data('calendar-component-id');
		var eventSources = this.EventSources[fullcalendarID];
	
		this.removeEventSources(fullcalendarID);
		if(selectedValue !== '0') {
			jQuery.each(eventSources, function( index, source ) {
				var url = source +'&ids[]=' + selectedValue;
				this.addEventSource(fullcalendarID, url);
			});
		} else {
			jQuery.each(eventSources, function( index, source ) {
				this.addEventSource(fullcalendarID, source);
			});
		}
		
	}
	
	/**
	// removeEventSources from calendar
	**/
	removeEventSources(fullcalendarID)
	{
		var calendarEl = document.getElementById(fullcalendarID);
		calendarEl.fullCalendar('removeEventSources');
	}
	
	/**
	// removeEventSource from calendar
	**/
	removeEventSource(fullcalendarID, eventSource)
	{
		var calendarEl = document.getElementById(fullcalendarID);
		calendarEl.fullCalendar('removeEventSource', eventSource).fullCalendar('refetchEvents');
	}
	
	/**
	// addEventSource from calendar
	**/
	addEventSource(fullcalendarID, eventSource)
	{
		var calendarEl = document.getElementById(fullcalendarID);
		calendarEl.fullCalendar('addEventSource', eventSource);
	}

}


