<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Site\Model;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\FormatHelper;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\Utils;

class EventsModel extends ListModel
{
	/**
     * Model context string.
     *
     * @var        string
     */
    protected $_context = 'com_easygcalendar.events';

	/** @var object parameters item */
	protected $params;
	/** @var int[] of calendar IDs */
	protected $calendarIDs;
	/** @var object calendar event items */
	protected $items;
	/** @var string reference type (com | mod ) */
	protected $refType;
	/** @var int reference ID */
	protected $refID;
	
	/**
     * Method to auto-populate the model state.
     *
     * This method should only be called once per instantiation and is designed
     * to be called on the first call to the getState() method unless the model
     * configuration flag to ignore the request is set.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @param   string  $ordering   An optional ordering field.
     * @param   string  $direction  An optional direction (asc|desc).
     *
     * @return  void
     *
     * @since   3.0.1
     */
    protected function populateState($ordering = 'ordering', $direction = 'ASC')
	{
		$app = Factory::getApplication();
		// Load the parameters.
		$params = $app->getParams();
		
		//Check for Menu Item parameters (component only)
		if(is_numeric($this->refID) && $this->refID > 0)
		{
			switch(strtolower($this->refType))
			{
				case 'com': //Component
					$tmpMenuItem = $app->getMenu()->getItem((int)$this->refID);
					if($tmpMenuItem)
					{
						// Merge global params with item params
						$tmpParams = clone $tmpMenuItem->getParams();
						$params->merge($tmpParams);
					}
				break;
				
				case 'mod': //Modules
					$moduleParams = Utils::getModuleParameterByID((int)$this->refID);
					if($moduleParams)
					{
						// Merge global params with item params
						$tmpParams = clone $moduleParams;
						$params->merge($tmpParams);
					}
				break;
			}
			//print "<br>DEBUG:Merged Params[event_show_url]->[".$params->get('event_show_url')."]";
		}
		
		$this->setState('params', $params);
		parent::populateState();
	}
	
	/** Get the parameters of the component (merged)
	 * @return object with the available parameters of the component.  */
	public function getParams()
	{
		$app = Factory::getApplication();
		$this->calendarIDs 	= $app->input->get('ids');
		$this->refType 		= $app->input->get('refType');
		$this->refID 		= $app->input->get('refID');
		
		if($this->params == null)
		{
			$this->params = $this->getState('params');
		}
		return $this->params;
	}
		
	/** Get a list of calendar items
	 * @return object  */
	public function getItems()
	{
		$app = Factory::getApplication();
		if($this->items == null)
		{
			//validate required params
			if(($this->refType != 'com' || $this->refType != 'mod') && $this->refID <= 0)
			{
				return;
			}
			
			// Load the Event-Data.	
			$startDate 	= FormatHelper::getDate($app->input->getHtml('start'), false, 'UTC');
			$endDate 	= FormatHelper::getDate($app->input->getRaw('end'), false, 'UTC');
			
			if($this->params == null)
			{	
				$this->getParams();
			}
			
			//Fallback use all selected calendar ids as default
			if($this->calendarIDs == null)
			{
				$this->calendarIDs =  $this->params->get('calendarids');
			}
			
			//Caching
			$paramCacheType 				=  $this->params->get('cache_type', 0);
			$paramCacheTimeInMinutes		= ((int) $this->params->get( 'cache_time', $app->get( 'cachetime' )) * 60); //The cachetime in minutes
			$isCachingEnabled = (($paramCacheType == 1 && $app->get( 'caching' )) || $paramCacheType == 2);
			$this->items = Utils::getCalendarData($this->calendarIDs, $startDate, $endDate, $this->refType, $this->refID, $isCachingEnabled, $paramCacheTimeInMinutes);
			
			$this->setState('items', $this->items );
		}
		
		return $this->items;
	}
}
?>