<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2025 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\Helper;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;
use Joomla\CMS\Log\Log;


/**
 * EasyGCalendar component helper base class
 */
class UtilsBaseClass
{
	//Component
	public static $extensionName = 'com_easygcalendar';
	public static $extension_prefix = 'EasyGCalendar';
	
	//Module(s)
	public static $moduleName = 'mod_easygcalendar';
	public static $moduleUpcomingName = 'mod_easygcalendar_upcoming';
	
	//Frontend Frameworks
	public static $frontendFrameworkBS4 = 'BS4'; //Bootstrap 4 EOL
	public static $frontendFrameworkBS5 = 'BS5'; //Bootstrap 5
	public static $frontendFrameworkUIKIT = 'UIKIT'; //UIKIT

	//Properties
	public static $calendarAccessRoleFreeBusy = 'freeBusyReader';
	public static $validRefTypes = array('com', 'mod', 'mod_upcomming');
	
	/**
	 * Method to get a component parameter
	 * @return object
	**/
	public static function getComponentParameter ($key, $defaultValue = null)
	{
		$params = ComponentHelper::getParams(self::$extensionName);
		return $params->get($key, $defaultValue);
	}
	
	/**
	 * Method to get the parameter set of a specific by ModuleID
	 * @return object
	**/
	public static function getModuleParameterByID ($moduleID)
	{
		//Get Module from Database
		$db = Factory::getDbo();
		$query = $db->getQuery(true)
			->select('m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params, mm.menuid')
			->from('#__modules AS m')
			->join('LEFT', '#__modules_menu AS mm ON mm.moduleid = m.id')
			->where('m.published = 1')
			->join('LEFT', '#__extensions AS e ON e.element = m.module AND e.client_id = m.client_id')
			->where('e.enabled = 1')
			->where('m.id = ' . $moduleID);
		
		// Set the query
		$db->setQuery($query);
		//echo "<br>DEBUG:SQL: ".$query;
		
		try
		{
			$module = $db->loadObject();
			if($module && $module->id == $moduleID)
			{
				// Get module parameters
				$params = new Registry;
				$params->loadString($module->params);
				return $params;
			}
		}
		catch (\RuntimeException $e)
		{
			Log::add(Text::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $e->getMessage()), Log::WARNING, 'jerror');
		}
		return null;
	}
	
	/**
	 * Method to check if the installed version includes PRO functionality
	 * @return boolean
	**/
	public static function isProVersion ($method="", $isPrintMessage=false)
	{
		if (file_exists(JPATH_ADMINISTRATOR . '/components/' . self::$extensionName .'/src/Helper/UtilsProVersion.php'))
		{
			//require_once(JPATH_ADMINISTRATOR . '/components/' . self::$extensionName .'/src/Helper/UtilsProVersion.php');
			if(method_exists('CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsProVersion', $method))
			{
				return true;
			}
		}
	
		if($isPrintMessage)
		{
			print('Message: There is no EasyGCalendar PRO version installed!');
		}
		return false;
	}
	
}
?>