<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2025 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\Helper;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;


/**
 * EasyGCalendar Html helper class.
 */
class HtmlHelper
{
	/**
	 * Method to get the Modal Html & style basesd on the selected frontend framework.
	 * @return html string
	**/
	public static function getModalContent($strUniqueID, $strFrontendFramework, $modalWidth, $modalHeight, $modalBodyHeight)
	{
		$strFrontendFramework = strtoupper($strFrontendFramework);
		
		$strContent = '<style>
				@media screen and (min-width: 768px) {
					#event-details-view-'. $strUniqueID .' .modal-dialog { '. $modalWidth . $modalHeight .' }
				}';
		
		if($strFrontendFramework == UtilsBaseClass::$frontendFrameworkBS5)
		{
			$strContent .= '
					div.modal { margin: 0 auto; text-align: center; padding: 0!important; }
					div.modal:before { content: \'\'; display: inline-block; height: 100%; vertical-align: middle; margin-right: -4px; }
					div.modal-dialog { display: inline-block; text-align: left; vertical-align: middle; }';
		}
		else if($strFrontendFramework == UtilsBaseClass::$frontendFrameworkUIKIT)
		{
			//TBD
		}

		$strContent .= '</style>';
		
		$strContent .= '<div id="event-details-view-'. $strUniqueID .'" class="modal fade modal-hidden" tabindex="-1" role="dialog" aria-labelledby="myModalLabel-'. $strUniqueID .'">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h2 class="modal-title" id="myModalLabel-'. $strUniqueID .'">&nbsp;</h2>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body" style="'.$modalBodyHeight.'">
										<iframe style="width:99.6%;height:95%;border:none;"></iframe>
									</div>
								</div>
							</div>
						</div>';
		
		return $strContent;
	}
	
	/**
	 * Method to get the copyright tag as string
	 * @return html string
	**/
	public static function getCopyrightTag()
	{
		return '<div><small>Copyright (C) 2011-2025 by <a href="https://codeninja.eu" target="_blank">codeninja.eu</a></small></div>';
	}

	/**
	 * Method to get the installed Version as string
	 * @return html string
	**/
	public static function getVersionTag($isOnlyVersion = false)
	{
		$name = '';
		$version = '';
		$file = JPATH_ADMINISTRATOR . '/components/com_easygcalendar/easygcalendar.xml';
		if(file_exists($file))
		{
			$xml = simplexml_load_file($file);
			$v = $xml->xpath('//extension');
			if(count($v) > 0)
			{
				$name = $v[0]->name;
				$version = $v[0]->version;
			}
		}

		if($isOnlyVersion) {
			return 'v' . $version;
		} else {
			return '<!-- '.$name.' v' . $version . ' -->';
		}
	}
}

?>