<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit https://codeninja.eu for updates and information.
**/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class implements ServiceProviderInterface
{

public function register(Container $container) 
{
  $container->registerServiceProvider(new MVCFactory('\\CodeNinja\\Component\\EasyGCalendar'));
  $container->registerServiceProvider(new ComponentDispatcherFactory('\\CodeNinja\\Component\\EasyGCalendar'));
  $container->set(
   ComponentInterface::class,
    function (Container $container) 
    {
       $component = new MVCComponent($container->get(ComponentDispatcherFactoryInterface::class));
       $component->setMVCFactory($container->get(MVCFactoryInterface::class));

       return $component;
    }
    );
 }
};

?>