<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Site\View\Event;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\Utils;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\UtilsProVersion;

/**
 * Raw View class for the GCalendar Component - Event - iCal Download
 */
class RawView extends BaseHtmlView
{
	protected $params;
	protected $objEvent;
	
	/**
	 * Method to display the view.
	 * @return void
	**/
	function display($tpl = null)
	{
		// Assign data to the view from Model
		$this->params 			 = $this->get('Params');
		$this->objEvent			 = $this->get('Event');
		
		// Check for errors.
		if (\count($errors = $this->get('Errors'))) {
			throw new GenericDataException(implode("\n", $errors), 500);
		}

		if ($this->objEvent != null && Utils::isProVersion('getICalDownload', true))
		{
			$fileType = 'ics';
			$fileName = $this->objEvent->title .'_'. $this->objEvent->start_date;
			$content = UtilsProVersion::getICalDownload($this->objEvent);
			header('Content-Type: text/calendar; charset=utf-8');
			header('Content-Disposition: attachment; filename="' . $fileName . '.ics"');
			echo $content;
		}
	}
}
?>
