<?php
/**
* @package EasyGCalendar
* @Copyright (C) 2011-2023 Daniel Blum. All rights reserved.
* @license Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
* @author Daniel Blum
* @website Visit http://codeninja.eu for updates and information.
**/

namespace CodeNinja\Component\EasyGCalendar\Administrator\Model;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Table\Table;
use Joomla\Database\ParameterType;
use CodeNinja\Component\EasyGCalendar\Administrator\Helper\DatabaseHelper;

//jimport('joomla.application.component.modellist');
//require_once(JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utilsBase.php');
//JLoader::register('EasyGCalendarHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/utils.php');
//JLoader::register('EasyGCalendarDatabaseHelper', JPATH_ADMINISTRATOR . '/components/com_easygcalendar/helpers/database.php');

/**
 * Methods supporting a list of records.
 */
class CalendarsModel extends ListModel
{
	public function __construct($config = [])
	{
		parent::__construct($config);
	}

	/**
	 * Build an SQL query to load the list data.
	 */

	protected function getListQuery()
	{
		$db = $this->getDatabase();
		$query = $db->getQuery(true);
		// Select the required fields from the table.
		$query->select('a.*')
			->from($db->quoteName(DatabaseHelper::$tablename, 'a'));
		return $query;
	}

	/*protected function getListQuery()
	{
		$db = Factory::getDBO();
		$query = $db->getQuery(true);

		$query->select('*');

		$query->from(DatabaseHelper::$tablename);
		return $query;
	}*/
}
?>
